/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.squiddev.cobalt.CachedMetamethod;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaDouble;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaUserdata;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;

public final class LuaTable
extends LuaValue {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final int[] EMPTY_NEXT = new int[0];
    private Object[] array = EMPTY_ARRAY;
    private Object[] keys = EMPTY_ARRAY;
    private Object[] values = EMPTY_ARRAY;
    private int[] next = EMPTY_NEXT;
    private int lastFree = 0;
    private boolean weakKeys;
    private boolean weakValues;
    private int metatableFlags;
    private LuaTable metatable;

    public LuaTable() {
        super(5);
    }

    public LuaTable(int arraySize, int hashSize) {
        super(5);
        this.resize(arraySize, hashSize, false);
    }

    @Override
    public LuaTable checkTable() {
        return this;
    }

    public void presize(int nArray) {
        if (nArray > this.array.length) {
            this.resize(nArray, this.keys.length, false);
        }
    }

    @Override
    public LuaTable getMetatable(@Nullable LuaState state) {
        return this.metatable;
    }

    @Override
    public void setMetatable(@Nullable LuaState state, LuaTable mt) {
        LuaValue mode;
        this.metatable = mt;
        boolean newWeakKeys = false;
        boolean newWeakValues = false;
        if (mt != null && (mode = mt.rawget(Constants.MODE)).isString()) {
            LuaString m = (LuaString)mode.toLuaString();
            if (m.indexOf((byte)107) >= 0) {
                newWeakKeys = true;
            }
            if (m.indexOf((byte)118) >= 0) {
                newWeakValues = true;
            }
        }
        if (newWeakKeys != this.weakKeys || newWeakValues != this.weakValues) {
            this.weakKeys = newWeakKeys;
            this.weakValues = newWeakValues;
            this.rehash(null, true);
        }
    }

    public LuaValue rawget(String key) {
        return this.rawget(ValueFactory.valueOf(key));
    }

    public void rawset(String key, LuaValue value) {
        this.rawsetImpl(ValueFactory.valueOf(key), value);
    }

    public void move(int from, int to, int count) {
        if (to >= from + count || to <= from) {
            for (int i = 0; i < count; ++i) {
                this.rawset(to + i, this.rawget(from + i));
            }
        } else {
            for (int i = count - 1; i >= 0; --i) {
                this.rawset(to + i, this.rawget(from + i));
            }
        }
    }

    public int length() {
        int a = this.array.length;
        if (a > 0 && this.rawget(a).isNil()) {
            int n = a + 1;
            int m = 0;
            while (n - m > 1) {
                int k = (m + n) / 2;
                if (this.rawget(k).isNil()) {
                    n = k;
                    continue;
                }
                m = k;
            }
            return m;
        }
        if (this.keys.length == 0) {
            return a;
        }
        long i = a;
        long j = i + 1L;
        while (!this.rawget((int)j).isNil()) {
            i = j;
            if ((j *= 2L) <= 0xFFFFFFFCL) continue;
            i = 1L;
            while (!this.rawget((int)i).isNil()) {
                ++i;
            }
            return (int)i - 1;
        }
        while (j - i > 1L) {
            int k = ((int)i + (int)j) / 2;
            if (!this.rawget(k).isNil()) {
                i = k;
                continue;
            }
            j = k;
        }
        return (int)i;
    }

    public int size() {
        int n = 0;
        for (Object k : this.array) {
            if (LuaTable.strengthen(k).isNil()) continue;
            ++n;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.key(i).isNil() || this.value(i).isNil()) continue;
            ++n;
        }
        return n;
    }

    public Varargs next(LuaValue key) throws LuaError {
        int i = this.findIndex(key);
        if (i < 0) {
            throw new LuaError("invalid key to 'next'");
        }
        while (i < this.array.length) {
            LuaValue value = LuaTable.strengthen(this.array[i]);
            if (!value.isNil()) {
                return ValueFactory.varargsOf((LuaValue)ValueFactory.valueOf(i + 1), (Varargs)value);
            }
            ++i;
        }
        i -= this.array.length;
        while (i < this.keys.length) {
            LuaValue thisKey = this.key(i);
            LuaValue thisValue = this.value(i);
            if (!thisKey.isNil() && !thisValue.isNil()) {
                return ValueFactory.varargsOf(thisKey, (Varargs)thisValue);
            }
            ++i;
        }
        return Constants.NIL;
    }

    private int findIndex(LuaValue key) {
        if (key.isNil()) {
            return 0;
        }
        int arrayIndex = LuaTable.arraySlot(key);
        if (arrayIndex > 0 && arrayIndex <= this.array.length) {
            return arrayIndex;
        }
        if (this.keys.length == 0) {
            return -1;
        }
        int idx = this.hashSlot(key);
        do {
            if (!this.key(idx).equals(key)) continue;
            return idx + this.array.length + 1;
        } while ((idx = this.next[idx]) >= 0);
        return -1;
    }

    private static int hashpow2(int hashCode, int mask) {
        return hashCode & mask;
    }

    private static int hashmod(int hashCode, int mask) {
        return (hashCode & Integer.MAX_VALUE) % (mask | 1);
    }

    private static int hashSlot(LuaValue key, int hashMask) {
        return switch (key.type()) {
            case 2, 3, 5, 7, 8 -> LuaTable.hashmod(key.hashCode(), hashMask);
            default -> LuaTable.hashpow2(key.hashCode(), hashMask);
        };
    }

    private static int arraySlot(LuaValue value) {
        LuaInteger i;
        int val;
        if (value instanceof LuaInteger && (val = (i = (LuaInteger)value).intValue()) > 0) {
            return val;
        }
        return 0;
    }

    private int hashSlot(LuaValue key) {
        return LuaTable.hashSlot(key, this.keys.length - 1);
    }

    private void dropWeakArrayValues() {
        for (int i = 0; i < this.array.length; ++i) {
            Object x = this.array[i];
            if (x == Constants.NIL || !LuaTable.strengthen(x).isNil()) continue;
            this.array[i] = Constants.NIL;
        }
    }

    private static int log2(int x) {
        return 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    private static Object[] setArrayVector(Object[] oldArray, int n, boolean metaChange, boolean weakValues) {
        int i;
        Object[] newArray = new Object[n];
        int len = Math.min(n, oldArray.length);
        if (metaChange) {
            for (i = 0; i < len; ++i) {
                LuaValue value = LuaTable.strengthen(oldArray[i]);
                newArray[i] = weakValues ? LuaTable.weaken(value) : value;
            }
        } else {
            System.arraycopy(oldArray, 0, newArray, 0, Math.min(n, oldArray.length));
        }
        for (i = oldArray.length; i < newArray.length; ++i) {
            newArray[i] = Constants.NIL;
        }
        return newArray;
    }

    private static int countInt(LuaValue key, int[] nums) {
        int idx = LuaTable.arraySlot(key);
        if (idx != 0) {
            int n = LuaTable.log2(idx);
            nums[n] = nums[n] + 1;
            return 1;
        }
        return 0;
    }

    private int numUseArray(int[] nums) {
        int ause = 0;
        int i = 1;
        int lg = 0;
        int ttlg = 1;
        while (lg <= 31) {
            int lc = 0;
            int lim = ttlg;
            if (lim > this.array.length && i > (lim = this.array.length)) break;
            while (i <= lim) {
                LuaValue value = LuaTable.strengthen(this.array[i - 1]);
                if (!value.isNil()) {
                    ++lc;
                }
                ++i;
            }
            int n = lg++;
            nums[n] = nums[n] + lc;
            ause += lc;
            ttlg *= 2;
        }
        return ause;
    }

    private void setNodeVector(int size) {
        if (size == 0) {
            this.values = EMPTY_ARRAY;
            this.keys = EMPTY_ARRAY;
            this.next = EMPTY_NEXT;
            this.lastFree = 0;
        } else {
            int lsize = LuaTable.log2(size);
            size = 1 << lsize;
            this.keys = new Object[size];
            this.values = new Object[size];
            this.next = new int[size];
            Arrays.fill(this.keys, Constants.NIL);
            Arrays.fill(this.values, Constants.NIL);
            Arrays.fill(this.next, -1);
            this.lastFree = size - 1;
        }
    }

    private void resize(int newArraySize, int newHashSize, boolean modeChange) {
        LuaValue value;
        int oldArraySize = this.array.length;
        int oldHashSize = this.keys.length;
        if (newArraySize > oldArraySize) {
            this.array = LuaTable.setArrayVector(this.array, newArraySize, modeChange, this.weakValues);
        }
        Object[] oldKeys = this.keys;
        Object[] oldValues = this.values;
        this.setNodeVector(newHashSize);
        if (newArraySize < oldArraySize) {
            Object[] oldArray = this.array;
            this.array = LuaTable.setArrayVector(oldArray, newArraySize, modeChange, this.weakValues);
            for (i = newArraySize; i < oldArraySize; ++i) {
                value = LuaTable.strengthen(oldArray[i]);
                if (value.isNil()) continue;
                this.rawset(i + 1, value);
            }
        } else if (newArraySize == oldArraySize && modeChange) {
            Object[] values = this.array;
            for (i = 0; i < oldArraySize; ++i) {
                value = LuaTable.strengthen(values[i]);
                values[i] = this.weakValues ? LuaTable.weaken(value) : value;
            }
        }
        for (int i = oldHashSize - 1; i >= 0; --i) {
            LuaValue key = LuaTable.key(oldKeys, oldValues, i, true);
            value = LuaTable.value(oldValues, i, true);
            if (key.isNil() || value.isNil()) continue;
            this.rawsetImpl(key, value);
        }
    }

    private void rehash(LuaValue extraKey, boolean mode) {
        int arrayCount;
        if (this.weakValues) {
            this.dropWeakArrayValues();
        }
        int[] nums = new int[32];
        int arraySize = 0;
        int totalCount = arrayCount = this.numUseArray(nums);
        int i = this.keys.length;
        while (--i >= 0) {
            LuaValue key = LuaTable.key(this.keys, this.values, i, true);
            LuaValue value = LuaTable.value(this.values, i, true);
            if (value.isNil()) continue;
            arrayCount += LuaTable.countInt(key, nums);
            ++totalCount;
        }
        if (extraKey != null) {
            arrayCount += LuaTable.countInt(extraKey, nums);
            ++totalCount;
        }
        int sum = 0;
        int numArray = 0;
        int i1 = 0;
        int twoPow = 1;
        while (arrayCount > twoPow / 2) {
            if (nums[i1] > 0 && (sum += nums[i1]) > twoPow / 2) {
                arraySize = twoPow;
                numArray = sum;
            }
            ++i1;
            twoPow *= 2;
        }
        assert ((arraySize == 0 || arraySize / 2 < numArray) && numArray <= arraySize);
        arrayCount = numArray;
        this.resize(arraySize, totalCount - arrayCount, mode);
    }

    private int getFreePos() {
        if (this.keys.length == 0) {
            return -1;
        }
        while (this.lastFree >= 0) {
            if (this.keys[this.lastFree--] != Constants.NIL) continue;
            return this.lastFree + 1;
        }
        return -1;
    }

    private LuaValue key(int slot) {
        return LuaTable.key(this.keys, this.values, slot, this.weakKeys);
    }

    private static LuaValue key(Object[] keys, Object[] values, int slot, boolean weak) {
        assert (keys.length == values.length);
        Object key = keys[slot];
        if (key == Constants.NIL || !weak) {
            return (LuaValue)key;
        }
        LuaValue strengthened = LuaTable.strengthen(key);
        if (strengthened.isNil()) {
            values[slot] = Constants.NIL;
        }
        return strengthened;
    }

    private LuaValue value(int slot) {
        return LuaTable.value(this.values, slot, this.weakValues);
    }

    private static LuaValue value(Object[] values, int slot, boolean weak) {
        Object value = values[slot];
        if (value == Constants.NIL || !weak) {
            return (LuaValue)value;
        }
        LuaValue strengthened = LuaTable.strengthen(value);
        if (strengthened.isNil()) {
            values[slot] = Constants.NIL;
        }
        return strengthened;
    }

    private void setNodeValue(int slot, LuaValue value) {
        this.values[slot] = this.weakValues ? LuaTable.weaken(value) : value;
        this.metatableFlags = 0;
    }

    private int newKey(LuaValue key) {
        if (key.isNil()) {
            throw new IllegalArgumentException("table index is nil");
        }
        if (this.keys.length == 0) {
            this.rehash(key, false);
            return -1;
        }
        int mainNode = this.hashSlot(key);
        LuaValue mainKey = this.key(mainNode);
        if (!mainKey.isNil() && !this.value(mainNode).isNil()) {
            int freeNode = this.getFreePos();
            if (freeNode < 0) {
                this.rehash(key, false);
                return -1;
            }
            int otherNode = this.hashSlot(mainKey);
            if (otherNode != mainNode) {
                while (this.next[otherNode] != mainNode) {
                    otherNode = this.next[otherNode];
                }
                this.next[otherNode] = freeNode;
                this.keys[freeNode] = this.keys[mainNode];
                this.values[freeNode] = this.values[mainNode];
                this.next[freeNode] = this.next[mainNode];
                this.next[mainNode] = -1;
                this.keys[mainNode] = Constants.NIL;
                this.values[mainNode] = Constants.NIL;
            } else {
                if (this.next[mainNode] != -1) {
                    this.next[freeNode] = this.next[mainNode];
                } else assert (this.next[freeNode] == -1);
                this.next[mainNode] = freeNode;
                mainNode = freeNode;
            }
        }
        this.keys[mainNode] = this.weakKeys ? LuaTable.weaken(key) : key;
        return mainNode;
    }

    private int getNode(int search) {
        if (this.keys.length == 0) {
            return -1;
        }
        int node = LuaTable.hashmod(search, this.keys.length - 1);
        do {
            LuaInteger keyI;
            LuaValue key;
            if (!((key = this.key(node)) instanceof LuaInteger) || (keyI = (LuaInteger)key).intValue() != search) continue;
            return node;
        } while ((node = this.next[node]) != -1);
        return -1;
    }

    private int getNode(LuaValue search) {
        if (this.keys.length == 0 || search == Constants.NIL) {
            return -1;
        }
        int node = this.hashSlot(search);
        do {
            LuaValue key;
            if (!(key = this.key(node)).equals(search)) continue;
            return node;
        } while ((node = this.next[node]) != -1);
        return -1;
    }

    public LuaValue rawget(int search) {
        if (search > 0 && search <= this.array.length) {
            return LuaTable.strengthen(this.array[search - 1]);
        }
        if (this.keys.length == 0) {
            return Constants.NIL;
        }
        int node = this.getNode(search);
        return node == -1 ? Constants.NIL : this.value(node);
    }

    public LuaValue rawget(LuaValue search) {
        if (search instanceof LuaInteger) {
            LuaInteger i = (LuaInteger)search;
            return this.rawget(i.intValue());
        }
        int node = this.getNode(search);
        return node == -1 ? Constants.NIL : this.value(node);
    }

    public LuaValue rawget(CachedMetamethod search) {
        LuaValue value;
        int flag = 1 << search.ordinal();
        if ((this.metatableFlags & flag) != 0) {
            return Constants.NIL;
        }
        int node = this.getNode(search.getKey());
        if (node != -1 && !(value = this.value(node)).isNil()) {
            return value;
        }
        this.metatableFlags |= flag;
        return Constants.NIL;
    }

    private boolean hasNewIndex() {
        LuaTable metatable = this.metatable;
        return metatable != null && metatable.rawget(CachedMetamethod.NEWINDEX) != Constants.NIL;
    }

    boolean trySet(int key, LuaValue value) {
        return this.trySet(key, value, null);
    }

    private boolean trySet(int key, LuaValue value, LuaValue keyValue) {
        if (key > 0 && key <= this.array.length) {
            if (LuaTable.strengthen(this.array[key - 1]) == Constants.NIL && this.hasNewIndex()) {
                return false;
            }
            this.array[key - 1] = this.weakValues ? LuaTable.weaken(value) : value;
            return true;
        }
        int node = this.getNode(key);
        if (node == -1) {
            if (this.hasNewIndex()) {
                return false;
            }
        } else {
            if (this.value(node) == Constants.NIL && this.hasNewIndex()) {
                return false;
            }
            this.setNodeValue(node, value);
            return true;
        }
        assert (!this.hasNewIndex());
        this.rawset(key, value, keyValue);
        return true;
    }

    boolean trySet(LuaValue key, LuaValue value) throws LuaError {
        if (key instanceof LuaInteger) {
            LuaInteger keyI = (LuaInteger)key;
            return this.trySet(keyI.intValue(), value, key);
        }
        int node = this.getNode(key);
        if (node == -1) {
            if (this.hasNewIndex()) {
                return false;
            }
        } else {
            if (this.value(node) == Constants.NIL && this.hasNewIndex()) {
                return false;
            }
            this.setNodeValue(node, value);
            return true;
        }
        assert (!this.hasNewIndex());
        this.rawset(key, value);
        return true;
    }

    public void rawset(int key, LuaValue value) {
        this.rawset(key, value, null);
    }

    private void rawset(int key, LuaValue value, LuaValue valueOf) {
        int node;
        do {
            if (key > 0 && key <= this.array.length) {
                this.array[key - 1] = this.weakValues ? LuaTable.weaken(value) : value;
                return;
            }
            node = this.getNode(key);
            if (node != -1) continue;
            if (valueOf == null) {
                valueOf = ValueFactory.valueOf(key);
            }
            node = this.newKey(valueOf);
        } while (node == -1);
        this.setNodeValue(node, value);
    }

    public void rawset(LuaValue key, LuaValue value) throws LuaError {
        LuaDouble d;
        if (key.isNil()) {
            throw new LuaError("table index is nil");
        }
        if (key instanceof LuaDouble && Double.isNaN((d = (LuaDouble)key).doubleValue())) {
            throw new LuaError("table index is NaN");
        }
        this.rawsetImpl(key, value);
    }

    public void rawsetImpl(LuaValue key, LuaValue value) {
        int node;
        if (key instanceof LuaInteger) {
            LuaInteger keyI = (LuaInteger)key;
            this.rawset(keyI.intValue(), value, key);
            return;
        }
        do {
            if ((node = this.getNode(key)) != -1) continue;
            node = this.newKey(key);
        } while (node == -1);
        this.setNodeValue(node, value);
    }

    private static Object weaken(LuaValue value) {
        return switch (value.type()) {
            case 5, 6, 8 -> new WeakReference<LuaValue>(value);
            case 7 -> new WeakUserdata((LuaUserdata)value);
            default -> value;
        };
    }

    static LuaValue strengthen(Object ref) {
        if (ref instanceof WeakReference) {
            LuaValue value = (LuaValue)((WeakReference)ref).get();
            return value == null ? Constants.NIL : value;
        }
        if (ref instanceof WeakUserdata) {
            return ((WeakUserdata)ref).strongValue();
        }
        return (LuaValue)ref;
    }

    private static final class WeakUserdata {
        private WeakReference<LuaValue> ref;
        private final WeakReference<Object> ob;
        private final LuaTable mt;

        private WeakUserdata(LuaUserdata value) {
            this.ref = new WeakReference<LuaUserdata>(value);
            this.ob = new WeakReference<Object>(value.instance);
            this.mt = value.metatable;
        }

        LuaValue strongValue() {
            LuaValue u = (LuaValue)this.ref.get();
            if (u != null) {
                return u;
            }
            Object o = this.ob.get();
            if (o != null) {
                LuaUserdata ud = ValueFactory.userdataOf(o, this.mt);
                this.ref = new WeakReference<LuaUserdata>(ud);
                return ud;
            }
            return Constants.NIL;
        }
    }
}

